<?php defined('PF_VERSION') OR exit('Access denied');?>
<div class="row">
    <div class="col-xs-12" style="overflow: auto;">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Layouts','theme');?>
                    <span class="small"><?php echo __('Layout designer','theme');?></span>
                </h3>
            </div>
            <div class="panel-body">
                <form method="post"
                    action="<?php echo admin_url('action=add&type=pattern&id='); ?>"
                    id="add-builder-form">
                    <div class="row pad">
                        <div class="col-md-5">
                            <div class="form-group <?php if (!empty($error['layout_name'])){?> has-error <?php }?>">
                                <label for="disabledTextInput"><?php echo __('Layout name','theme');?></label>
						          <?php echo form_input('layout_name'); ?>
						          <?php if (!empty($error['layout_name'])){?><p class="help-block"><?php echo $error['layout_name'][0]?></p><?php }?>
						    </div>
                        </div>
                    </div>
                    <div class="row pad">
                        <div class="col-sm-3" id="plugins">
                            <ul class="sortable-list">
                            <?php foreach ($widgets as $k => $widget) { ?>
                                <?php if (!in_array($k, $active_widgets)) continue;?>
                                <li class="sortable-item" id="widget_<?php echo $k;?>"><?php echo htmlspecialchars_decode($widget['name']);?></li>
                            <?php }?>
                            </ul>
                        </div>
                        <div class="col-sm-9">
                            <div id="layout_buider_container">
                                <table class="table table-bordered">
                                    <tr>
                                        <td colspan="3">
                                            <ul
                                                class="sortable-list ui-sortable"
                                                id="panel_1"></ul>
                                        </td>
                                    </tr>
                                    <tr valign="middle" align="center">
                                        <td style="width: 300px;">
                                            <ul
                                                class="sortable-list ui-sortable"
                                                id="panel_2"></ul>
                                        </td>
                                        <td>
                                            <div
                                                style="font-size: 3em; padding: 100px 0;">
                                                <strong><?php echo __('Main','theme');?></strong>
                                            </div>
                                        </td>
                                        <td style="width: 300px;">
                                            <ul
                                                class="sortable-list ui-sortable"
                                                id="panel_3"></ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="3">
                                            <ul
                                                class="sortable-list ui-sortable"
                                                id="panel_4"></ul>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
					<?php echo form_hidden('url_save',admin_url('action=add&type=save'));?>
					<?php echo form_hidden('old_pattern',4); ?>
					<?php echo form_hidden('pattern',4); ?>
					<?php echo form_hidden('json_data','{}');?>
					<?php echo form_hidden('setting_data','{}');?>
				</form>
                <div class="row pad">
                    <div class="col-md-12">
                        <?php add_toolbar_button(form_button('<i class="fa fa-angle-double-left"></i> &nbsp; '. __('Back','theme') ,
						array('id'=>"back-add-pattern",'class' => 'btn btn-default')));?>
                            
                        <?php add_toolbar_button(form_button('<i class="fa fa-floppy-o"></i> &nbsp; '. __('Save','theme') ,
						array('id'=>"btn_builder_layout",'class' => 'btn btn-primary')));?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo form_hidden('setting_form_url',admin_url('action=setting-form'))?>
<script>
pf_layout_setting.relative_path = "<?php echo RELATIVE_PATH; ?>";
pf_layout_setting.delete_widget_message = "<?php echo __('Are you sure to delete widget?','theme'); ?>";
pf_layout_setting.ok_button_message = "<?php echo __('Ok','theme'); ?>";
pf_layout_setting.delete_button_message = "<?php echo __('Delete','theme'); ?>";
pf_layout_setting.cancel_button_message = "<?php echo __('Cancel','theme'); ?>";
$(document).ready(function(){
	$('#btn_builder_layout').click(function(){
		$('#json_data').val(pf_build_layout_json_data());
		$('#add-builder-form').attr('action',$('#url_save').val());
		$('#add-builder-form').submit();
	});
	
	if ($('#old_pattern').val() != $('#pattern').val()){
		$('#json_data').val('{}');
	}
	$('#old_pattern').val($('#pattern').val());
	pf_rebuild_layout();
});
</script>